% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groups.R
\name{get_groups}
\alias{get_groups}
\title{Get group information from the Posit Connect server}
\usage{
get_groups(src, page_size = 500, prefix = NULL, limit = Inf)
}
\arguments{
\item{src}{The source object.}

\item{page_size}{The number of records to return per page (max 500).}

\item{prefix}{Filters groups by prefix (group name).
The filter is case insensitive.}

\item{limit}{The number of groups to retrieve before paging stops.

\code{limit} will be ignored is \code{prefix} is not \code{NULL}.
To limit results when \code{prefix} is not \code{NULL}, change \code{page_size}.}
}
\value{
A tibble with the following columns:
\itemize{
\item \code{guid}: The unique identifier of the group
\item \code{name}: The group name
\item \code{owner_guid}: The group owner's unique identifier. When using LDAP or
Proxied authentication with group provisioning enabled this property
will always be null.
}
}
\description{
Get group information from the Posit Connect server
}
\details{
Please see https://docs.posit.co/connect/api/#get-/v1/groups for more information.
}
\examples{
\dontrun{
library(connectapi)
client <- connect()

# get all groups
get_groups(client, limit = Inf)
}

}
\seealso{
Other groups functions: 
\code{\link{get_group_content}()},
\code{\link{get_group_members}()}
}
\concept{groups functions}
