% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comm.simul.R
\name{comm.simul}
\alias{comm.simul}
\title{Framework for community assembly simulation}
\usage{
comm.simul(
  x = vector(),
  S = 200,
  J = 300,
  rand.seed = NULL,
  sim.length = 1,
  fSpecPool = "Gener.species.pool",
  competition.kernel = "Gaussian.competition.kernel",
  fSurvive = "Gaussian.tolerance",
  fSeedProduction = "SeedProduction",
  fDispersal = "MetaCom.Dispersal",
  fITV = "randomITV",
  verbose = FALSE,
  ...
)
}
\arguments{
\item{x}{Vector of environmental values in communities. If not given, 40
communities are created, with environmental variable equally
spacing from 0.11 to 0.89}

\item{S}{Species pool size}

\item{J}{Number of individuals in each community}

\item{rand.seed}{Random seed number. Setting the same value allows repeating
the same simulation}

\item{sim.length}{Length of simulation. \code{sim.length*S} cycle (disturbance-seed
production-dispersal-establishment) will happen.}

\item{fSpecPool}{Name of (the user defined) function that generates the
species pool. See \code{\link{Gener.species.pool}}}

\item{competition.kernel}{Name of the (user defined) function for calculating
pairwise competition coefficients. See more details
in available functions and specification of your own
function in \code{\link{competition.kernel}}}

\item{fSurvive}{Name of the (user defined) function for calculating survival
probability of seeds. See more details
in available functions and specification of your own
function in \code{\link{tolerance}}}

\item{fSeedProduction}{Name of the user defined function for calculating
number of produced seeds See \code{\link{SeedProduction}}}

\item{fDispersal}{Name of the user defined function for dispersal of
produced seeds among local communities.
See more details in available functions and specification
of your own function in \code{\link{fDispersal}}}

\item{fITV}{Name of the function that define seeds trait values, possibly
considering mother's trait and mothers environment.
If "noITV", there is no intraspecific trait variation.
See more details in available functions and specification
of your own function in \code{\link{fITV}}}

\item{verbose}{Runing may take long time. If \code{verbose} set to \code{TRUE},
it writes messages into the screen indicating the progress.}

\item{...}{Additional parameters of functions called by the framework.}
}
\value{
A list with two elements:

\code{$final.community} a dataframe containing data on individuals in the final meta-community.
                        Each individual represented by a row; columns are: sub-community,
                        species identity, trait values.

\code{$parameters} list of simulation parameters (including parameters of functions called by the framework function)
}
\description{
Flexible framework of individual-based simulation of community assembly
following framework proposed by Botta-Dukat & Czucz (2016), but allowing
intraspecific trait variation (ITV)
}
\details{
This function is a framework for simulation of assembly in a meta-community.
The simulation consists of a community initialization followed by an
iterative simulation of a "disturbance–regeneration" cycle.
During initialization a species pool is created defining each species by
its trait values. Each locality is characterized by an environmental variable.
Initial composition of local communities is a random selection from the species
pool: species identity is selected independently for each individal with
probability of seedling survival (that depends on local environment and trait value).


The "disturbance-regeneration" cycle consists of the following steps:
\enumerate{
      \item disturbance event: some randomly selected individuals
            die in each community
      \item survivors produce seeds. Seed production depends on fertility
            of the locality and competition among coexisting individuals
      \item seeds are dispersed among localities
      \item all seeds germinate and seedlings struggle for survival. The number of
            adults in local communities is fixed, thus number of seedlings that can
            survive and grow up equals to the number of individulas died in the
            disturbance event (in the recent version one individual dies, but planed development
            is introducing a disturbance severity/number of deaths parameter)
}


It is a flexible framework that calls funcions for:

\itemize{
   \item generating species pool
         (\code{\link{Gener.species.pool}})
   \item calculating pairwise competition coefficients
         (\code{\link{competition.kernel}})
   \item calculating seedling's survival probabilities
         (\code{\link{tolerance}})
   \item calculating number of produced seeds
         (\code{\link{SeedProduction}})
   \item calculating trait values of offsprings
         (\code{\link{fITV}})
   \item seed dispersal among localities
         (\code{\link{fDispersal}})
        }
Functions available in the package can be easily replaced by user-defined
functions.
}
\examples{
w<-comm.simul(S=20, J=30)
str(w)

set.seed(1)
w<-comm.simul(S=20, J=30, fITV=NULL)$final.community
w[w[,2]==1,] # Each individuals belonging to Species1 has the same trait values
}
\references{
Botta-Dukat Z, Czucz B (2016) Testing the ability of
functional diversity indices to detect trait convergence and divergence
using individual-based simulation.
\emph{Methods in Ecology and Evolution} \bold{7}(1): 114-126.
\url{http://dx.doi.org/10.1111/2041-210X.12450}
}
