% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codemetar.R
\docType{package}
\name{codemetar-package}
\alias{codemetar}
\alias{codemetar-package}
\title{codemetar: generate codemeta metadata for R packages}
\description{
The 'Codemeta' Project defines a JSON-LD format for describing software metadata,
as detailed at https://codemeta.github.io.
This package provides utilities to generate, parse, and modify codemeta.jsonld
files automatically for R packages, as well as tools and examples for working
with codemeta JSON-LD more generally.
}
\details{
It has three main goals:

\itemize{
\item Quickly generate a valid codemeta.json file from any valid R package
  To do so, we automatically extract as much metadata as possible using
  the DESCRIPTION file, as well as extracting metadata from other common
  best-practices such as the presence of Travis and other badges in README, etc.
\item Facilitate the addition of further metadata fields into a codemeta.json
  file, as well as general manipulation of codemeta files.
\item Support the ability to crosswalk between terms used in other metadata standards,
  as identified by the Codemeta Project Community, see https://codemeta.github.io/crosswalk
}

To learn more about codemetar, start with the vignettes:
`browseVignettes(package = "codemetar")`

For more general information about the CodeMeta Project for defining software metadata,
see https://codemeta.github.io.  In particular, new users might want to start with
the User Guide (https://codemeta.github.io/user-guide/), while those looking to learn
more about JSON-LD and consuming existing codemeta files should see the
Developer Guide (https://codemeta.github.io/developer-guide/).
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/ropensci/codemetar}
  \item Report bugs at \url{https://github.com/ropensci/codemetar/issues}
}

}
\author{
\strong{Maintainer}: Carl Boettiger \email{cboettig@gmail.com} (0000-0002-1642-628X) [copyright holder]

}
