% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{plot_timeSeries}
\alias{plot_timeSeries}
\title{Time series plot (multifaceted)}
\usage{
plot_timeSeries(df_result, start_time, end_time, sample_time, tick_time, ...)
}
\arguments{
\item{df_result}{Data frame containing results to plot. Must have column $time.}

\item{start_time}{Plot start time.}

\item{end_time}{Plot end time.}

\item{sample_time}{Time interval to subset data.}

\item{tick_time}{X-axis label break interval time (default 2*sample_time).}

\item{...}{... <\code{\link[tidyselect:language]{tidy-select}}> Columns to plot.}
}
\value{
ggplot object of faceted time series
}
\description{
Provides convenience function to plot simulation trajectory of result from
one run as time series. Supports plotting multiple states in faceted plot.
}
\details{
Support the following features:
\enumerate{
\item flexible start-end time of the series by \code{start_time} and \code{end_time}.
\item row subset of data by a fixed \code{sample_time} (useful when time step is small for numerical precision).
\item flexible time tick label spacing by \code{tick_time}.
\item states to plot are selected by \code{tidy-select}.
}

Please note that this function does not attempt to do exhaustive sanity
check of parameters Make sure yourself that parameters make sense (e.g.,
end-start time must be longer than sample_time and tick_time, etc.)
}
\examples{
vignette("clock-models", "clockSim")
}
