% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_probs_lm.R
\name{add_probs.lm}
\alias{add_probs.lm}
\title{Response Level Probabilities for Linear Models}
\usage{
\method{add_probs}{lm}(
  tb,
  fit,
  q,
  name = NULL,
  yhatName = "pred",
  comparison = "<",
  log_response = FALSE,
  ...
)
}
\arguments{
\item{tb}{A tibble or data frame of new data.}

\item{fit}{An object of class \code{lm}. Predictions are made with
this object.}

\item{q}{A real number. A quantile of the response distribution.}

\item{name}{\code{NULL} or a string. If \code{NULL}, probabilities
automatically will be named by \code{add_probs}, otherwise, the
probabilities will be named \code{name} in the returned tibble.}

\item{yhatName}{A character vector of length one. Names of the}

\item{comparison}{\code{"<"}, or \code{">"}. If \code{comparison =
"<"}, then \eqn{Pr(Y|x < q)} is calculated for each observation in
\code{tb}. Otherwise, \eqn{Pr(Y|x > q)} is calculated.}

\item{log_response}{A logical. Default is \code{FALSE}. Set to
\code{TRUE} if the model is log-linear: \eqn{\log(Y) = X \beta
+ \epsilon}.}

\item{...}{Additional arguments.}
}
\value{
A tibble, \code{tb}, with predicted values and
    probabilities attached.
}
\description{
This is the method \code{add_probs} uses if the model is of class
\code{lm}. Probabilities are calculated parametrically,
using a pivotal quantity.
}
\examples{

# Fit a linear model
fit <- lm(dist ~ speed, data = cars)

# Calculate the probability that a new dist will be less than 20,
# given the model.
add_probs(cars, fit, q = 20)

# Calculate the probability that a new dist will be greater than
# 30, given the model.
add_probs(cars, fit, q = 30, comparison = ">")

}
\seealso{
\code{\link{add_ci.lm}} for confidence intervals for
    \code{lm} objects, \code{\link{add_pi.lm}} for prediction
    intervals of \code{lm} objects, and
    \code{\link{add_quantile.lm}} for response quantiles of
    \code{lm} objects.
}
