% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_tables.R
\name{DataTables}
\alias{DataTables}
\alias{graph_attr_dt}
\alias{vertex_attr_dt}
\title{Create a data table with graph global and vertex measures}
\usage{
graph_attr_dt(g.list, group = NULL)

vertex_attr_dt(g, group = NULL)
}
\arguments{
\item{g.list}{A list of \code{igraph} graph objects}

\item{group}{A character string indicating group membership (default:
\code{NULL})}

\item{g}{An \code{igraph} graph object}
}
\value{
A \code{data.table}
}
\description{
\code{graph_attr_dt} is a helper function that takes a list of graphs and
creates a \code{data.table} of global measures for each graph. Each row will
be for a different graph.

\code{vertex_attr_dt} is a helper function that creates a \code{data.table}
in which each row is a vertex and each column is a different network measure
(degree, centrality, etc.). It is partly a wrapper for
\code{\link[igraph]{as_data_frame}}.
}
\examples{
\dontrun{
dt.V <- vertex_attr_dt(g)
setcolorder(dt.V, c('modality', 'atlas', 'Group', names(dt.V)[1:28]))
}
}
\seealso{
\code{\link[igraph]{graph_attr}, \link[igraph]{graph_attr_names}}

\code{\link[igraph]{vertex_attr}, \link[igraph]{vertex_attr_names},
\link[igraph]{as_data_frame}}
}
