% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{cor.diff.test}
\alias{cor.diff.test}
\title{Calculate the p-value for differences in correlation coefficients}
\usage{
cor.diff.test(r1, r2, n1, n2, alternative = c("two.sided", "less",
  "greater"))
}
\arguments{
\item{r1}{Numeric (vector or matrix) of correlation coefficients, group 1}

\item{r2}{Numeric (vector or matrix) of correlation coefficients, group 2}

\item{n1}{Integer; number of observations, group 1}

\item{n2}{Integer; number of observations, group 2}

\item{alternative}{Character string specifying the alternative hypothesis
test to use; one of: 'two.sided' (default), 'less', 'greater'}
}
\value{
A list containing:
\item{p}{The p-values}
\item{z}{The z-score for the difference in correlation coefficients}
}
\description{
Given two sets of correlation coefficients and sample sizes, this function
calculates and returns the \emph{z-scores} and \emph{p-values} associated
with the difference between correlation coefficients. This function was
adapted from \url{http://stackoverflow.com/a/14519007/3357706}.
}
\examples{
\dontrun{
kNumSubjs <- summary(covars$Group)
corr.diffs <- cor.diff.test(corrs[[1]][[1]]$R, corrs[[2]][[1]]$R,
                            kNumSubjs[1], kNumSubjs[2], alternative='two.sided')
edge.diffs <- t(sapply(which(corr.diffs$p < .05), function(x)
                       mapply('[[',
                              dimnames(corr.diffs$p),
                              arrayInd(x, dim(corr.diffs$p)))
                              ))
}
}
\seealso{
Other Matrix functions: \code{\link{apply_thresholds}},
  \code{\link{create_mats}}, \code{\link{symmetrize_mats}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\concept{Matrix functions}
