% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm_stats.R
\name{GLM influence measures}
\alias{GLM influence measures}
\alias{rstandard.bg_GLM}
\alias{rstudent.bg_GLM}
\alias{hatvalues.bg_GLM}
\alias{cooks.distance.bg_GLM}
\alias{dffits.bg_GLM}
\alias{dfbeta.bg_GLM}
\alias{dfbetas.bg_GLM}
\alias{covratio.bg_GLM}
\alias{influence.bg_GLM}
\title{Influence measures for a bg_GLM object}
\usage{
\method{rstandard}{bg_GLM}(model, type = c("sd.1", "predictive"), ...)

\method{rstudent}{bg_GLM}(model, ...)

\method{hatvalues}{bg_GLM}(model, ...)

\method{cooks.distance}{bg_GLM}(model, ...)

dffits.bg_GLM(model)

\method{dfbeta}{bg_GLM}(model, ...)

\method{dfbetas}{bg_GLM}(model, ...)

covratio.bg_GLM(model)

\method{influence}{bg_GLM}(model, do.coef = TRUE, ...)
}
\arguments{
\item{model}{A \code{bg_GLM} object}

\item{type}{The type of standardized residuals. Default: \code{'sd.1'}}

\item{...}{Unused}

\item{do.coef}{Logical indicating whether to calculate \code{dfbeta}}
}
\value{
Most influence functions return a numeric matrix in which rownames
  are Study ID's and column names are regions. \code{dfbeta} and
  \code{dfbetas} return a numeric array in which each column is a parameter
  estimate and the 3rd dimension is for each region. \code{influence} returns
  a list with class \code{infl.bg_GLM} and elements:
  \item{infmat}{Numeric array (like \code{dfbeta}) with DFBETAs, DFFITs,
    covratios, Cook's distance, and hat values}
  \item{is.inf}{Logical array of the same data as \code{infmat}; values of
    \code{TRUE} indicate the subject-variable-region combination is an
    outlier value}
  \item{f}{The model \emph{formula}}
  \item{sigma}{The leave-one-out residual standard deviation}
  \item{wt.res}{Model residuals}
}
\description{
These functions compute common (leave-one-out) diagnostics for the models in
a \code{bg_GLM} object.
}
\details{
The \code{influence} method calculates all diagnostics present in
\code{\link[stats]{lm.influence}} and
\code{\link[stats]{influence.measures}}, consisting of the following
functions:
\describe{
  \item{rstandard}{Standardized residuals. Choosing \code{type='predictive'}
    returns leave-one-out cross validation residuals. The \dQuote{PRESS}
    statistic can be calculated as \code{colSums(resids.p^2)}}
  \item{rstudent}{Studentized residuals}
  \item{hatvalues}{The \emph{leverage}, or the diagonal of the
    \emph{hat/projection matrix}}
  \item{cooks.distance}{Cook's distance}
  \item{dffits.bg_GLM}{The change in fitted values when deleting
    observations}
  \item{dfbeta}{The change in parameter estimates (coefficients) when
    deleting observations}
  \item{dfbetas}{The \emph{scaled} change in parameter estimates}
  \item{covratio.bg_GLM}{The covariance ratios, or the change in the
    determinant of the covariance matrix of parameter estimates when deleting
    observations}
}
}
\section{Outlier values}{

Each variable has a different criterion for determining outliers. In the
following: \code{x} is the influence variable (for \code{DFBETA}, the
criterion applies to all DFBETAs); \code{k} is the number of columns of the
design matrix; \code{dfR} is the residual degrees of freedom; and \code{n} is
the number of observations.
\describe{
  \item{DFBETAs}{If \eqn{|x| > 1}}
  \item{DFFITs}{If \eqn{|x| > 3 \sqrt{k / dfR}}}
  \item{covratio}{If \eqn{|1 - x| > (3k / dfR)}}
  \item{cook}{If \eqn{F_{k, dfR}(x) > 0.5}}
  \item{hat}{If \eqn{x > 3k / n}}
}
The return object of \code{influence} has a \code{print} method which will
list the subjects/variables/regions for which an outlier was detected.
}

\seealso{
\code{\link{GLM}}
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
