% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_global.R
\name{plot_global}
\alias{plot_global}
\title{Plot global graph measures across densities}
\usage{
plot_global(tidy.dt, legend.pos = c(1, 0), vline = NULL,
  level.names = NULL, exclude = NULL, perms = NULL, g = NULL,
  alt = NULL)
}
\arguments{
\item{tidy.dt}{A \code{\link{data.table}} that has been "tidied", containing
global graph measures for all densities and subject groups}

\item{legend.pos}{A numeric vector indicating the legend position (default:
c(1, 0))}

\item{vline}{Numeric; required to plot a dashed vertical line (default: NULL)}

\item{level.names}{Character vector of facet label names, if you wish to
change them (default: NULL)}

\item{exclude}{Character vector of variables to exclude (default: NULL)}

\item{perms}{A \code{\link{data.table}} of permutation group differences
(default: NULL)}

\item{g}{A list of lists of \code{igraph} graph objects; required if
\emph{perms} is provided (default: NULL)}

\item{alt}{Character vector of alternative hypotheses; required if
\emph{perms} is provided (default: NULL)}
}
\value{
A \code{\link[ggplot2]{ggplot}} object
}
\description{
Create a faceted line plot of global graph measures across a range of graph
densities. Given a "tidied" \code{data.table}, you can choose to insert a
dashed vertical line at a density of interest, rename the variable levels
(which become the facet titles), exclude certain variables, and include a
\code{data.table} of permutation data to add asterisks indicating signficant
group differences.
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}

