% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_brainnet.R
\name{write.brainnet}
\alias{write.brainnet}
\title{Write files to be used for visualization with BrainNet Viewer}
\usage{
write.brainnet(g, node.color = c("none", "community", "lobe"),
  node.size = "constant", file.prefix = "")
}
\arguments{
\item{g}{A graph}

\item{node.color}{Character string indicating whether to color the nodes or
not; can be 'none', 'lobe', or 'community'}

\item{node.size}{Character string indicating what size the nodes should be;
can be any vertex-level attribute (default: 'constant')}

\item{file.prefix}{Character string for the basename of the \emph{.node} and
\emph{.edge} files that are written}
}
\description{
This function will write the \emph{.node} and \emph{.edge} files necessary
for visualization with the BrainNet Viewer software (see Reference below).
}
\details{
For the \emph{.node} file, there are 6 columns:
\itemize{
\item \emph{Column 1}: x-coordinates
\item \emph{Column 2}: y-coordinates
\item \emph{Column 3}: z-coordinates
\item \emph{Column 4}: Vertex color
\item \emph{Column 5}: Vertex size
\item \emph{Column 6}: Vertex label
}
The \emph{.edge} file is the graph's associated adjacency matrix.
}
\author{
Christopher G. Watson, \email{cgwatson@bu.edu}
}
\references{
Xia M, Wang J, He Y (2013). \emph{BrainNet Viewer: a network
visualization tool for human brain connectomics}. PLoS One, 8(7):e68910.
}

