% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AntalTille_UPS.R
\name{define_phi}
\alias{define_phi}
\title{Define the phi vector}
\usage{
define_phi(phi)
}
\arguments{
\item{phi}{vector of inclusion probabilities for Antal and Tillé (2011) bootstrap, 
given by 1 - D_kk}
}
\value{
a list with the two vectors in which \code{phi} is decomposed
}
\description{
Define the phi vector used to select the first sample in Antal & Tillé (2011)
bootstrap (algorithm 4, first step).
If the sum of the elements of \eqn{\phi}{phi} is not an integer, phi is decomposed 
in a convex combination of two vectors \eqn{\phi_1}{phi1} and \eqn{\phi_2}{phi2}, 
such that the sum of \eqn{\phi_1i}{phi1_i} is the integer part of \eqn{\sum phi_i}{sum(phi_i)} 
and the sum of \eqn{\phi_2i}{phi2_i} is the integer part of \eqn{\sum phi_i}{sum(phi_i)} plus 1 
[see Antal and Tille' (2011) bootstrap procedure
for unequal probability sampling, p. 539 - Algorithm 4, Case 1]
The procedure used to decompose the vector \eqn{\phi}{phi} is described in the 
answer to this question: https://math.stackexchange.com/questions/2700483/vector-decomposition-into-a-convex-combination-of-two-vectors-with-constraints-o
}
\keyword{internal}
