% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aesthetics.R
\name{newaxes}
\alias{newaxes}
\title{Aesthetics for supplementary (new) biplot axes}
\usage{
newaxes(bp, X.new.names=bp$var.names, which = 1:bp$num.vars, col = "orange", lwd = 1, 
lty = 1, label.dir = "Orthog", label.col = col, label.cex = 0.75, label.line = 0.1, 
ticks = 5, tick.col = col, tick.size = 1, tick.label = TRUE, tick.label.col = tick.col, 
tick.label.cex = 0.6, tick.label.side = "below", predict.col = col, predict.lwd = lwd, 
predict.lty = lty, ax.names = X.new.names, orthogx = 0, orthogy = 0)
}
\arguments{
\item{bp}{object of class \code{biplot}}

\item{X.new.names}{refers to the new column names of \code{bp} to specify which axes to label.}

\item{which}{vector of new columns to be displayed in the biplot.}

\item{col}{vector of size p specifying colours of labels of biplot axes. The default is \code{grey(0.7)}.}

\item{lwd}{axis line width, with default \code{1}.}

\item{lty}{axis line type, with default \code{1}.}

\item{label.dir}{One of "Orthog" (default), "Hor" or "Paral" specifying titles of
axes to appear orthogonal to the side of the figure; always
horizontally or always parallel to the side of the figure.}

\item{label.col}{axis label colour, with default, \code{col}.}

\item{label.cex}{axis label expansion, with default \code{0.75}.}

\item{label.line}{axis label written on which margin line, with default \code{0.1}.}

\item{ticks}{integer-valued vector of size equal to the number of biplot axes
to control the number of tickmarks on each individual biplot
axis. Default is 5 for each axis.}

\item{tick.col}{tick mark colour, with default \code{col}.}

\item{tick.size}{positive integer-valued vector with specifying tick mark sizes, with default \code{1}.}

\item{tick.label}{logical, whether axes should be labelled or not, with default \code{TRUE}.}

\item{tick.label.col}{tick mark label colour, with default \code{tick.col}.}

\item{tick.label.cex}{tick mark label expansion, with default \code{0.6}.}

\item{tick.label.side}{character vector specifying position of the tick label "below" or "above" the axis.}

\item{predict.col}{predicted samples colour, with default \code{col}.}

\item{predict.lwd}{predicted samples line width, with default \code{lwd}.}

\item{predict.lty}{predicted samples line type, with default \code{lty}.}

\item{ax.names}{vector of size \code{p} containing user defined names for the variables.}

\item{orthogx}{numeric vector of size p specifying the x-coordinate of the parallel transformation of each axis.
Defaults to zero for each axis. Only used when the dimension of the biplot is two.}

\item{orthogy}{numeric vector of size p specifying the y-coordinate of the parallel transformation of each axis.
Defaults to zero for each axis. Only used when the dimension of the biplot is two.}
}
\value{
an object of class \code{biplot}
}
\description{
Aesthetics for supplementary (new) biplot axes
}
\examples{
biplot(data = iris[,1:2]) |> PCA() |> interpolate(newvariable = iris[3:4]) |> 
  newaxes(col="gold") |> plot()
}
