% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/biplot.R
\name{legend.type}
\alias{legend.type}
\title{Format the legend for the biplot}
\usage{
legend.type(bp, samples = FALSE, means = FALSE, bags = FALSE,
                   ellipses=FALSE,regions=FALSE, new=FALSE, ...)
}
\arguments{
\item{bp}{an object of class \code{biplot}.}

\item{samples}{a logical value indicating whether a legend should be printed for samples, with default \code{FALSE}.}

\item{means}{a logical value indicating whether a legend should be printed for means, with default \code{FALSE}.}

\item{bags}{a logical value indicating whether a legend should be printed for bags, with default \code{FALSE}.}

\item{ellipses}{a logical value indicating whether a legend should be printed for concentration ellipses, with default \code{FALSE}.}

\item{regions}{a logical value indicating whether a legend should be printed for classification regions, with default \code{FALSE}.}

\item{new}{a logical value indicating whether the legend should appear in a new window, with default \code{FALSE}.}

\item{...}{additional arguments to be sent to \code{legend()}.}
}
\value{
A list with the following components is available:
\item{samples}{a logical value indicating whether a legend for samples are provided.}
\item{means}{a logical value indicating whether a legend for class means are provided.}
\item{bags}{a logical value indicating whether a legend for \eqn{\alpha}-bags are provided.}
\item{ellipses}{a logical value indicating whether a legend for \eqn{\kappa}-ellipses are provided.}
\item{regions}{a logical value indicating whether a legend for classification regions are provided.}
\item{new}{a logical value indicating whether the legend appears on new plot.}
}
\description{
This function enables the user to format the legend and make a required selection to display.
}
\examples{
biplot (iris[,1:4], Title="Test biplot") |> PCA(group.aes = iris[,5]) |>
    legend.type(samples=TRUE) |> plot()
    
}
