% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cql-geom-predicates.R
\name{cql_geom_predicates}
\alias{cql_geom_predicates}
\alias{EQUALS}
\alias{DISJOINT}
\alias{INTERSECTS}
\alias{TOUCHES}
\alias{CROSSES}
\alias{WITHIN}
\alias{CONTAINS}
\alias{OVERLAPS}
\alias{RELATE}
\alias{BBOX}
\alias{DWITHIN}
\alias{BEYOND}
\title{CQL Geometry Predicates}
\usage{
EQUALS(geom)

DISJOINT(geom)

INTERSECTS(geom)

TOUCHES(geom)

CROSSES(geom)

WITHIN(geom)

CONTAINS(geom)

OVERLAPS(geom)

RELATE(geom, pattern)

BBOX(coords, crs = NULL)

DWITHIN(geom, distance, units = c("meters", "feet", "statute miles",
  "nautical miles", "kilometers"))

BEYOND(geom, distance, units = c("meters", "feet", "statute miles",
  "nautical miles", "kilometers"))
}
\arguments{
\item{geom}{an sf/sfc/sfg object}

\item{pattern}{spatial relationship specified by a DE-9IM matrix pattern.
A DE-9IM pattern is a string of length 9 specified using the characters
\code{*TF012}. Example: \code{'1*T***T**'}}

\item{coords}{the coordinates of the bounding box.}

\item{crs}{(Optional) A string containing an SRS code
(For example, 'EPSG:1234'. The default is to use the CRS of the queried layer)}

\item{distance}{numeric value for distance tolerance}

\item{units}{units that distance is specified in. One of
\code{"feet"}, \code{"meters"}, \code{"statute miles"}, \code{"nautical miles"}, \code{"kilometers"}}
}
\value{
a CQL expression using the bounding box of the geom
}
\description{
Functions to construct a CQL expression to be used
to filter results from \code{\link[=bcdc_query_geodata]{bcdc_query_geodata()}}.
See \href{https://docs.geoserver.org/stable/en/user/filter/ecql_reference.html#spatial-predicate}{the geoserver CQL documentation for details}.
The sf object is automatically converted in a
bounding box to reduce the complexity of the Web Service call. Subsequent in-memory
filtering may be needed to achieve exact results.
}
