% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcmc-overview.R
\name{MCMC-overview}
\alias{MCMC-overview}
\alias{MCMC}
\title{Plots for Markov chain Monte Carlo simulations}
\description{
The \strong{bayesplot} MCMC module provides various plotting functions for
creating graphical displays of Markov chain Monte Carlo (MCMC) simulations.
The \strong{MCMC plotting functions} section, below, provides links to the
documentation for various categories of MCMC plots. Currently the MCMC
plotting functions accept posterior draws provided in one of the following
formats:
\itemize{
\item \strong{3-D array}: An array with dimensions \verb{Iteration, Chain, Parameter} in
that order.
\item \strong{list}: A list of matrices, where each matrix corresponds to a Markov
chain. All of the matrices should have the same number of iterations (rows)
and parameters (columns), and parameters should have the same names and be in
the same order.
\item \strong{matrix (2-D array)}: A matrix with one column per parameter. If using
matrix there should only be a single Markov chain or all chains should
already be merged (stacked).
\item \strong{data frame}: There are two types of data frames allowed. Either a data
frame with one column per parameter (if only a single chain or all chains
have already been merged), or a data frame with one column per parameter plus
an additional column \code{"Chain"} that contains the chain number (an integer)
corresponding to each row in the data frame.
\item \strong{draws}: Any of the \code{draws} formats supported by the
\pkg{posterior} package.
}

\strong{Note}: typically the user should \emph{not} include warmup iterations
in the object passed to \strong{bayesplot} plotting functions, although for
certain plots (e.g. trace plots) it can occasionally be useful to include the
warmup iterations for diagnostic purposes.
}
\section{MCMC plotting functions}{

\itemize{
\item \link[=MCMC-distributions]{Posterior distributions}:
Histograms and kernel density plots of parameter draws, optionally
showing each Markov chain separately.
\item \link[=MCMC-intervals]{Uncertainty intervals}: Uncertainty intervals computed
from parameter draws.
\item \link[=MCMC-traces]{Trace plots}: Times series of parameter draws, optionally
including HMC/NUTS diagnostic information.
\item \link[=MCMC-scatterplots]{Scatterplots}: Scatterplots, heatmaps, and pairs
plots of parameter draws, optionally including HMC/NUTS diagnostic
information.
\item \link[=MCMC-parcoord]{Parallel coordinates plots}: Parallel coordinates plot
of MCMC draws (one dimension per parameter), optionally including
HMC/NUTS diagnostic information.
\item \link[=MCMC-combos]{Combos}: Combination plots (e.g. trace plot + histogram).
\item \link[=MCMC-diagnostics]{General MCMC diagnostics}: MCMC diagnostic plots
including R-hat, effective sample size, autocorrelation.
\link[=MCMC-nuts]{NUTS diagnostics}: Special diagnostic plots for
the No-U-Turn Sampler.
\item \link[=MCMC-recover]{Comparisons to "true" values}: Plots comparing MCMC
estimates to "true" parameter values (e.g., values used to simulate data).
}
}

\references{
Gabry, J. , Simpson, D. , Vehtari, A. , Betancourt, M. and
Gelman, A. (2019), Visualization in Bayesian workflow.
\emph{J. R. Stat. Soc. A}, 182: 389-402. doi:10.1111/rssa.12378.
(\href{https://rss.onlinelibrary.wiley.com/doi/full/10.1111/rssa.12378}{journal version},
\href{https://arxiv.org/abs/1709.01449}{arXiv preprint},
\href{https://github.com/jgabry/bayes-vis-paper}{code on GitHub})
}
\seealso{
Other MCMC: 
\code{\link{MCMC-combos}},
\code{\link{MCMC-diagnostics}},
\code{\link{MCMC-distributions}},
\code{\link{MCMC-intervals}},
\code{\link{MCMC-nuts}},
\code{\link{MCMC-parcoord}},
\code{\link{MCMC-recover}},
\code{\link{MCMC-scatterplots}},
\code{\link{MCMC-traces}}
}
\concept{MCMC}
