% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hillModel.R
\name{invertHillModel}
\alias{invertHillModel}
\title{Calculates the required doses of a Hill dose response model}
\usage{
invertHillModel(effect, hpar, invalidNA = FALSE)
}
\arguments{
\item{effect}{A vector of desired response values}

\item{hpar}{A four parameter vector specifying the Hill model. Parameter
details are found in the documentation for \code{\link[=evalHillModel]{evalHillModel()}}}

\item{invalidNA}{Specifies what to do with values that are outside the range
of the given Hill model.  If \code{FALSE} (the default), values "below" the given
range will be set to zero, and values "above" the given range will be set to
Inf.  If \code{TRUE}, invalid values will be set to \code{NA}.}
}
\value{
A vector of concentrations the same length as \code{effect}.
}
\description{
This funciton takes one or more desired response values and determines the
doses that will produce the desired effects given a particular Hill dose
response model. This is useful for estimating things like IC50.
}
\examples{
invertHillModel(0.5, c(1,2,0,0.7))

invertHillModel(seq(0.1,0.9,by=0.1), c(0.1,4,0,0.65), invalidNA=TRUE)
}
