% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/authoriseGitHub.R
\name{authoriseGitHub}
\alias{authoriseGitHub}
\title{Authorise with GitHub API}
\usage{
authoriseGitHub(ClientID, ClientSecret, scope = c("public_repo"))
}
\arguments{
\item{ClientID}{A 20 characters long string with Client ID. See https://github.com/settings/applications/ for more details.}

\item{ClientSecret}{A 40 characters long string with Client Secret. See https://github.com/settings/applications/ for more details.}

\item{scope}{A character vector with the list of availables scopes for the GitHub API token. See \href{https://developer.github.com/v3/oauth/#scopes}{https://developer.github.com/v3/oauth/#scopes}.
For repository deletion you will need to add \code{"delete_repo"} scope.}
}
\description{
\code{authoriseGitHub} is function that performes OAuth authorisation with GitHub API 
and stores resulting token in the \code{github_token} variable.
In order to authorise your app you need ClinetID and ClientSecret.
They can be found here: https://github.com/settings/applications/new
}
\note{
Bug reports and feature requests can be sent to \href{https://github.com/MarcinKosinski/archivist.github/issues}{https://github.com/MarcinKosinski/archivist.github/issues}
}
\examples{
\dontrun{
## GitHub version
authoriseGitHub(ClientID, ClientSecret) -> github_token
}
}
\author{
Przemyslaw Biecek, \email{przemyslaw.biecek@gmail.com}
}
\references{
More about \pkg{archivist.github} can be found on 
\href{http://marcinkosinski.github.io/archivist.github/}{marcinkosinski.github.io/archivist.github/} 
and about \pkg{archivist} in posts' history on \href{http://pbiecek.github.io/archivist/Posts.html}{http://pbiecek.github.io/archivist/Posts.html}
}
\seealso{
Other archivist.github: \code{\link{archive}},
  \code{\link{archivist.github-package}},
  \code{\link{cloneGitHubRepo}},
  \code{\link{createGitHubRepo}},
  \code{\link{deleteGitHubRepo}},
  \code{\link{pushGitHubRepo}}
}

