% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_grid.R
\name{read_grid}
\alias{read_grid}
\title{Download spatial hexagonal grid H3}
\usage{
read_grid(city, showProgress = FALSE)
}
\arguments{
\item{city}{Character. A city name or three-letter abbreviation. If
\code{city="all"}, results for all cities are loaded.}

\item{showProgress}{Logical. Defaults to \code{TRUE} display progress bar}
}
\value{
An \verb{sf data.frame} object
}
\description{
Results of the AOP project are spatially aggregated on a hexagonal grid based
on the global H3 index at resolution 8, with a size of 357 meters (short
diagonal) and an area of 0.74 km2. More information about H3 at
\url{https://h3geo.org/docs/core-library/restable/}.  See documentation
'Details' for the data dictionary.
}
\section{Data dictionary:}{
\tabular{lll}{
   \strong{Data type} \tab \strong{column} \tab \strong{Description} \cr
   geographic \tab \code{abbrev_muni} \tab Abbreviation of city name (3 letters) \cr
   geographic \tab \code{name_muni} \tab City name \cr
   geographic \tab \code{code_muni} \tab 7-digit code of each city \cr
   geographic \tab \code{id_hex} \tab Unique id of hexagonal cell \cr
}
}

\examples{
\donttest{
# Read spatial grid of a single city
nat <- read_grid(city = 'Natal', showProgress = FALSE)

# Read spatial grid of all cities in the project
# all <- read_grid(city = 'all', showProgress = FALSE)
}
}
\concept{spatial data functions}
