% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{full_control_positions}
\alias{full_control_positions}
\title{full_control_positions}
\usage{
full_control_positions(
  design,
  x = "col",
  y = "row",
  factor_name = "trt",
  labels = "plots",
  width = 1,
  height = 1,
  space_width = 0.95,
  space_height = 0.85,
  reverse_y = FALSE,
  reverse_x = FALSE,
  shift_x = 0,
  shift_y = 0,
  start_origin = FALSE
)
}
\arguments{
\item{design}{data.frame containing the row and columns of an experiment}

\item{x}{Describes the x coordinates of a experiment design}

\item{y}{Describes the y coordinates of a experiment design}

\item{factor_name}{string Which factor should be used for plotting, needs to be a column in outdesign$book}

\item{labels}{string Describes the column from that the plots are taken to display them}

\item{width}{numeric value, describes the width of a plot in an experiment}

\item{height}{numeric value, describes the height of a plot in an experiment}

\item{space_width}{numeric value, describes the share of the space of the plots. 0=only space, 1=no space between plots in term of width}

\item{space_height}{numeric value, describes the share of the space of the plots. 0=only space, 1=no space between plots in term of height}

\item{reverse_y}{boolean, should the plots of the experiment be changed in reverse order in Row direction? use reverse_y=TRUE to have same sketch as in agricolae. default:reverse_y=FALSE}

\item{reverse_x}{boolean, should the plots of the experiment be changed in reverse order in column direction? default:reverse_x=FALSE}

\item{shift_x}{numeric indicates the shift in units in x-axis.}

\item{shift_y}{numeric indicates the shift in units for the y-axis.}

\item{start_origin}{boolean. Should the design start at the origin (0|0)?}
}
\value{
\code{ggplot} graphic that can be modified, if wished
}
\description{
This function provides full control about the plotting. The user also may shift the coordinates as liked.
}
\examples{
library(agricolaeplotr)
library(agricolae)
varieties<-c('perricholi','yungay','maria bonita','tomasa')
outdesign <-design.youden(varieties,r=2,serie=2,seed=23)
design <- outdesign$book
design
p <- full_control_positions(design,"col","row","varieties","plots",
                       width=3,height=4.5,
                       space_width=0.5,space_height=0.5,
                       shift_x=(-0.5*3) + (-0.5*3*0.5),shift_y=-0.5*4.5 + (-0.5*4.5*0.5))
p
p <- full_control_positions(design,"col","row","varieties","plots",
                       width=3,height=4.5,
                       space_width=0.13,space_height=0.445,
                       shift_x=(-0.5*3) + (-0.5*3*(1-0.13)),shift_y=-0.5*4.5 + (-0.5*4.5*(1-0.445)))
                       p

p <- full_control_positions(design,"col","row","varieties","plots",
                       width=3,height=4.5,
                       space_width=1,space_height=1,
                       shift_x=-0.5*3,shift_y=-0.5*4.5)
p

p <- full_control_positions(design,"col","row","varieties","plots",
                       width=3,height=4.5,
                       space_width=0.93,space_height=0.945,
                       start_origin = TRUE)
                       p
}
