#' Sales index for large retailers in Spain
#'
#' Sales index for food of large retailers in Spain
#'
#' @format Time series objects.
#' \describe{
#'   Monthly data from January 1995 to December 2019
#' }
#'
#' @source \href{http://serviciosede.mineco.gob.es/indeco/}{sales}
#'         
#' @examples
#' \dontrun{
#'  sales
#' }
"sales"

#' US GDP
#'
#' Seasonally adjusted quarterly US real gross domestic product (USgdp).
#'
#' @format Time series objects.
#' \describe{
#'   Quarterly data from 1962 to 2019
#' }
#'
#' @source \href{https://www.nber.org/}{USgdp}
#'         
#' @examples
#' \dontrun{
#'  USgdp
#' }
"USgdp"

#' OECD GDP
#'
#' Seasonally adjusted quarterly OECD real gross domestic product (OECDgdp).
#'
#' @format Time series objects.
#' \describe{
#'   Quarterly data from 1962 to 2019
#' }
#'
#' @source \href{http://serviciosede.mineco.gob.es/indeco/}{OECDgdp}
#'         
#' @examples
#' \dontrun{
#'  OECDgdp
#' }
"OECDgdp"

#' Methane concentration at Cape Grim in Australia (ch4).
#'
#' @format Time series objects.
#' \describe{
#'   Monthly data from January 1992 to December 2019
#' }
#'
#' @source \href{https://www.csiro.au/en/Research/OandA/Areas/Assessing-our-climate/Latest-greenhouse-gas-data}{CH4 data}
#'         
#' @examples
#' \dontrun{
#'  ch4
#' }
"ch4"

#' Airpassengers in Spain
#' 
#' Foreign arrivals by air in Spain in thousands of passengers (airpas).
#'
#'
#' @format Time series objects.
#' \describe{
#'   Monthly data from January 1992 to December 2019
#' }
#'
#' @source \href{https://www.ine.es}{airpas}
#' 
#' @examples
#' \dontrun{
#'  airpas
#' }
"airpas"
