% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tmvt.R
\name{dtmvt}
\alias{dtmvt}
\title{Density function for the truncated multivariate Student distribution}
\usage{
dtmvt(x, mu, sigma, df, lb, ub, type = c("mc", "qmc"), log = FALSE, B = 10000)
}
\arguments{
\item{x}{vector or matrix of quantiles}

\item{mu}{vector of location parameters}

\item{sigma}{scale matrix}

\item{df}{degrees of freedom}

\item{lb}{vector of lower truncation limits}

\item{ub}{vector of upper truncation limits}

\item{type}{string, either of \code{mc} or \code{qmc} for Monte Carlo and quasi Monte Carlo, respectively}

\item{log}{logical; if \code{TRUE}, probabilities and density are given on the log scale.}

\item{B}{number of replications for the (quasi)-Monte Carlo scheme}
}
\description{
This function returns the (log)-density of a matrix \code{x} of observations lying in the interval [\code{lb}, \code{ub}].
}
\seealso{
\code{\link{tmvt}}
}
\keyword{internal}
