% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{SpectrumLegend}
\alias{SpectrumLegend}
\title{Produce a legend for continuous gradient scales}
\usage{
SpectrumLegend(
  x0 = 0.05,
  y0 = 0.05,
  x1 = x0,
  y1 = y0 + 0.2,
  absolute = FALSE,
  legend = character(0),
  palette,
  lwd = 4,
  lty = 1,
  lend = "square",
  pos = 4,
  ...
)
}
\arguments{
\item{x0, y0, x1, y1}{Coordinates of the bottom-left and top-right end of the
bar.}

\item{absolute}{Logical specifying whether \code{x} and \code{y} values denote
coordinates (\code{TRUE}) or relative position, where (0, 0) denotes the
bottom-left of the plot area and (1, 1) the top right.}

\item{legend}{Character vector with which to label points on \code{palette}.}

\item{palette}{Colour palette to depict.}

\item{lwd, lty, lend}{Additional parameters to \code{\link[=segments]{segments()}},
controlling line style.}

\item{pos, \dots}{Additional parameters to \code{\link[=text]{text()}}.}
}
\description{
Prints an annotated vertical bar coloured according to a continuous palette.
}
\details{
This convenience function is not yet very customizable; do file a GitHub
issue if you would value additional functionality.
}
\examples{
plot(0:1, 0:1, type = "n", frame.plot = FALSE,
     xlab = "x", ylab = "y")
SpectrumLegend(legend = c("Dark", "Middle", "Bright"),
               palette = hcl.colors(32L), lwd = 5)
SpectrumLegend(0.4, 0.95, 0.9, 0.95, abs = TRUE,
               legend = seq(1, 9, by = 2), palette = 1:9, pos = 1)
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
