% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parse_files.R
\name{ReadCharacters}
\alias{ReadCharacters}
\alias{ReadTntCharacters}
\alias{ReadAsPhyDat}
\alias{ReadTntAsPhyDat}
\alias{PhyDat}
\title{Read phylogenetic characters from file}
\usage{
ReadCharacters(filepath, character_num = NULL, session = NULL)

ReadTntCharacters(filepath, character_num = NULL, session = NULL)

ReadAsPhyDat(filepath)

ReadTntAsPhyDat(filepath)

PhyDat(dataset)
}
\arguments{
\item{filepath}{character string specifying location of file}

\item{character_num}{Index of character(s) to return.
\code{NULL}, the default, returns all characters.}

\item{session}{(Optional) A Shiny session with a \code{numericInput} named
\code{character_num} whose maximum should be updated.}

\item{dataset}{list of taxa and characters, in the format produced by \link{read.nexus.data}:
a list of sequences each made of a single character vector,
and named with the taxon name.}
}
\value{
\code{ReadCharacters()} and \code{ReadTNTCharacters()} return a matrix whose
row names correspond to
tip labels, and column names correspond to character labels, with the
attribute \code{state.labels} listing the state labels for each character; or
a list of length one containing a character string explaining why the
function call was unsuccessful.

\code{ReadAsPhyDat()} and \code{ReadTntAsPhyDat()} return a
\code{\link[phangorn:phyDat]{phyDat}} object.
}
\description{
Parse a Nexus or TNT file, reading character states and names.
}
\details{
Tested with matrices downloaded from \href{https://morphobank.org}{MorphoBank},
but should also work more widely; please
\href{https://github.com/ms609/TreeTools/issues/new?title=Error+parsing+Nexus+file&body=<!--Tell+me+more+and+attach+your+file...-->}{report}
incorrectly parsed files.

Matrices must contain only continuous or only discrete characters;
maximum one matrix per file.  Continuous characters will be read as strings
(i.e. base type 'character').
}
\section{Functions}{
\itemize{
\item \code{PhyDat}: A convenient wrapper for \pkg{phangorn}'s
\code{phyDat()}, which converts a \strong{list} of morphological characters into a
\code{phyDat} object.
If your morphological characters are in the form of a \strong{matrix}, perhaps
because they have been read using \code{\link[=read.table]{read.table()}}, try \code{\link[=MatrixToPhyDat]{MatrixToPhyDat()}}
instead.
}}

\examples{
fileName <- paste0(system.file(package='TreeTools'),
                   '/extdata/input/dataset.nex')
ReadCharacters(fileName)

fileName <- paste0(system.file(package='TreeTools'),
                   '/extdata/tests/continuous.nex')
continuous <- ReadCharacters(fileName)

# To convert from strings to numbers:
at <- attributes(continuous)
continuous <- suppressWarnings(as.numeric(continuous))
attributes(continuous) <- at
continuous

}
\references{
\insertRef{Maddison1997}{TreeTools}
}
\seealso{
Convert between matrices and \code{phyDat} objects: \code{\link[=MatrixToPhyDat]{MatrixToPhyDat()}}
}
\author{
Martin R. Smith (\href{mailto:martin.smith@durham.ac.uk}{martin.smith@durham.ac.uk})
}
