context("pp_ProfileScore.R")
test_that("Profile score calculated correctly", {
  data(referenceTree)
  data(congreveLamsdellMatrices)
  tree <- referenceTree
  suppressWarnings(RNGversion("3.5.0")) # Until we can require R3.6.0
  set.seed(0)
  dataset <- PrepareDataProfile(congreveLamsdellMatrices[[1]], 4e+04, warn=FALSE)
  expect_equal(Fitch(tree, dataset), 
               sum(CharacterLength(tree, dataset) * attr(dataset, 'weight')))
  score <- ProfileScore(tree, dataset)
  expect_true(abs(354.58 + score) < 9) # Range as concavity constants generated by approximation
})
