% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_rearrangement.R
\name{CollapseNode}
\alias{CollapseNode}
\alias{CollapseEdge}
\title{Collapse nodes on a phylogenetic tree}
\usage{
CollapseNode(tree, nodes)

CollapseEdge(tree, edges)
}
\arguments{
\item{tree}{A tree of class \code{\link{phylo}}.}

\item{nodes, edges}{Integer vector specifying the nodes or edges in the tree
 to be dropped. 
(Use [ape:nodelabels] or [ape:edgelabels] to view numbers on a plotted tree.)}
}
\value{
`tree`, with the specified nodes or edges collapsed.  
The length of each dropped edge will (naively) be added to each descendant edge.
}
\description{
Collapse nodes on a phylogenetic tree
}
\examples{
  library(ape)
  set.seed(1)
  
  tree <- rtree(7)
  par(mfrow=c(2, 1), mar=rep(0.5, 4))
  plot(tree)
  nodelabels()
  edgelabels(round(tree$edge.length, 2), cex=0.6, frame='n', adj=c(1, -1))
  
  newTree <- CollapseNode(tree, c(12, 13))
  plot(newTree)
  nodelabels()
  edgelabels(round(newTree$edge.length, 2), cex=0.6, frame='n', adj=c(1, -1))

}
\author{
Martin R. Smith
}
