% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stem_segmentation_methods.R
\name{sgt.ransac.cylinder}
\alias{sgt.ransac.cylinder}
\title{Stem segmentation algorithm: RANSAC cylinder fit}
\usage{
sgt.ransac.cylinder(tol = 0.1, n = 10, conf = 0.95, inliers = 0.9)
}
\arguments{
\item{tol}{\code{numeric} - tolerance offset between absolute radii estimates and hough transform estimates.}

\item{n}{\code{numeric} - number of points selected on every RANSAC iteration.}

\item{conf}{\code{numeric} - confidence level.}

\item{inliers}{\code{numeric} - expected proportion of inliers among stem segments' point cloud chunks.}
}
\description{
This function is meant to be used inside \code{\link{stemSegmentation}}. It applies a least squares cylinder fit algorithm in a RANSAC fashion over stem segments. More details are given in the sections below.
}
\section{Random Sample Consensus (RANSAC) Algorithm}{


\loadmathjax

The \strong{RAN}dom \strong{SA}mple \strong{C}onsensus algorithm is a method that relies on resampling 
a data set as many times as necessary to find a subset comprised of only inliers - e.g. observations
belonging to a desired model. The RANSAC algorithm provides a way of estimating the necessary number of
iterations necessary to fit a model using inliers only, at least once, as shown in the equation:
\mjdeqn{k = log(1 - p) / log(1 - w^{n})}{k = log(1 - p) / log(1 - w^n)}
where:
\itemize{
\item \emph{k}: number of iterations
\item \emph{p}: confidence level, i.e. desired probability of success 
\item \emph{w}: proportion of inliers expected in the \emph{full} dataset
\item \emph{n}: number of observations sampled on every iteration
}

The models reiterated in \emph{TreeLS} usually relate to circle or cylinder 
fitting over a set of 3D coordinates, selecting the best possible model through the RANSAC algorithm

For more information, checkout \href{https://en.wikipedia.org/wiki/Random_sample_consensus}{this wikipedia page}.
}

\section{Least Squares Cylinder Fit}{


\loadmathjax

The cylinder fit methods implemented in \emph{TreeLS} estimate a 3D
cylinder`s axis direction and radius. The algorithm used internally
to optimize the cylinder parameters is the
\href{https://en.wikipedia.org/wiki/Nelder-Mead_method}{Nelder-Mead simplex},
which takes as objective function the model describing the distance from any point
to a modelled cylinder`s surface on a regular 3D cylinder point cloud:

\mjdeqn{D_{p} = |(p - q) \times a| - r}{Dp = abs((p - q) x a) - r}

where:

\itemize{
   \item \emph{Dp}: distance from a point to the model cylinder`s surface
   \item \emph{p}: a point on the cylinder`s surface
   \item \emph{q}: a point on the cylinder`s axis
   \item \emph{a}: unit vector of cylinder`s direction
   \item \emph{r}: cylinder`s radius
}

The Nelder-Mead algorithm minimizes the sum of squared \emph{Dp} from
a set of points belonging to a stem segment - in the context of \emph{TreeLS}.

The parameters returned by the cylinder fit methods are:
\itemize{
   \item \code{rho,theta,phi,alpha}: 3D cylinder estimated axis parameters (Liang et al. 2012)
   \item \code{Radius}: 3D cylinder radius, in point cloud units
   \item \code{Error}: model cylinder error from the least squares fit
   \item \code{AvgHeight}: average height of the stem segment's points
   \item \code{N}: number of points belonging to the stem segment
   \item \code{PX,PY,PZ}: absolute center positions of the stem segment points, in point cloud units (used for plotting)
 }
}

\references{
Liang, X. et al., 2012. Automatic stem mapping using single-scan terrestrial laser scanning. IEEE Transactions on Geoscience and Remote Sensing, 50(2), pp.661–670.

Olofsson, K., Holmgren, J. & Olsson, H., 2014. Tree stem and height measurements using terrestrial laser scanning and the RANSAC algorithm. Remote Sensing, 6(5), pp.4323–4344.

Conto, T. et al., 2017. Performance of stem denoising and stem modelling algorithms on single tree point clouds from terrestrial laser scanning. Computers and Electronics in Agriculture, v. 143, p. 165-176.
}
