% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stem_segmentation_methods.R
\name{sgt.bf.cylinder}
\alias{sgt.bf.cylinder}
\title{Stem segmentation algorithm: Brute Force cylinder fit}
\usage{
sgt.bf.cylinder(tol = 0.1, n = 10, conf = 0.95, inliers = 0.9, z_dev = 30)
}
\arguments{
\item{tol}{\code{numeric} - tolerance offset between absolute radii estimates and hough transform estimates.}

\item{n}{\code{numeric} - number of points selected on every RANSAC iteration.}

\item{conf}{\code{numeric} - confidence level.}

\item{inliers}{\code{numeric} - expected proportion of inliers among stem segments' point cloud chunks.}

\item{z_dev}{\code{numeric} - maximum angle deviation for brute force cylinder estimation (\code{bf}), i.e. angle, in degrees (0-90), that a cylinder can be tilted in relation to a perfect vertival axis (\code{Z = c(0,0,1)}).}
}
\description{
This function is meant to be used inside \code{\link{stemSegmentation}}. It applies a least squares cylinder fit algorithm in a RANSAC fashion over stem segments. More details are given in the sections below.
}
\section{Brute Force Cylinder Fit}{


The brute force cylinder fit approach estimates the axis rotation
angles by brute force combined with 2D ransac circle fit. The coordinates
of a point cloud representing a single cylinder are iteratively rotated up
to a pre defined threshold, and for every iteration a circle is estimated after
rotation is performed. The rotation that minimizes the circle parameters the most
is used to describe the axis direction of the cylinder with the circle's radius.

The parameters returned by the brute force cylinder fit method are:
\itemize{
   \item \code{X,Y}: 2D circle center coordinates after rotation
   \item \code{Radius}: 3D circle radius, in point cloud units
   \item \code{Error}: model circle error from the RANSAC least squares fit, after rotation
   \item \code{DX,DY}: absolute rotation angles (in degrees) applied to the X and Y axes, respectively
   \item \code{AvgHeight}: average height of the stem segment's points
   \item \code{N}: number of points belonging to the stem segment
 }
}

