% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{stemPoints}
\alias{stemPoints}
\title{Stem points classification}
\usage{
stemPoints(las, map = NULL, method = stem.hough())
}
\arguments{
\item{las}{\code{LAS} object.}

\item{map}{optional - map of tree positions (output from \code{\link{treeMap}} or \code{\link{treePositions}}). If omitted, the algorithm assumes \code{las} is a single tree.}

\item{method}{stem denoising algorithm - currently available: \code{\link{stem.hough}}.}
}
\value{
\code{LAS} object with \emph{stem_points} signature.
}
\description{
Classify stem points on a \strong{normalized} point cloud.
}
\examples{
### single tree
file = system.file("extdata", "pine.laz", package="TreeLS")
tls = readTLS(file)
tls = stemPoints(tls)
plot(tls, color='Stem')

### forest plot - check the example given for the stem segmentation function
?stemSegmentation

}
