% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stem_points_methods.R
\name{stem.hough}
\alias{stem.hough}
\title{Stem denoising algorithm: Hough Transform}
\usage{
stem.hough(hstep = 0.5, max_radius = 0.25, hbase = c(1, 2.5),
  pixel_size = 0.025, min_density = 0.1, min_votes = 3)
}
\arguments{
\item{hstep}{\code{numeric} - height interval to perform circle search.}

\item{max_radius}{\code{numeric} - approximately the largest stem cross section radius expected in the point cloud.}

\item{hbase}{\code{numeric} vector of length 2 - tree base height interval to initiate the circle search.}

\item{pixel_size}{\code{numeric} - pixel side length to discretize the point cloud layers while performing the Hough Transform circle search.}

\item{min_density}{\code{numeric} - between 0 and 1 - minimum point density within a pixel evaluated on the Hough Transform - i.e. only \emph{dense} point clousters will undergo circle search.}

\item{min_votes}{\code{integer} - Hough Transform parameter - minimum number of circle intersections over a pixel to assign it as a circle center candidate.}
}
\description{
This function is meant to be used inside \code{\link{stemPoints}}. It applies an adapted version of the Hough Transform for circle search. Mode details are given in the sections below.
}
\section{\code{LAS@data} Special Fields}{


Meaninful fields in the output:

\itemize{
\item \code{TreeID}: unique tree ID of the point - available when a \emph{tree_map} is provided
\item \code{Stem}: \code{TRUE} for stem points
\item \code{Segment}: stem segment number (from bottom to top)
\item \code{Radius}: approximate radius of the point's stem segment estimated by the Hough Transform - always a multiple of the \code{pixel_size}
\item \code{Votes}: votes received by the stem segment's center through the Hough Transform
}
}

\section{Adapted Hough Transform}{


The Hough Transform circle search algorithm used in
TreeLS applies a constrained circle search on discretized 
point cloud layers. Tree-wise, the circle search is  
recursive, in which the search for circle parameters 
of a stem section is constrained to the 
\emph{feature space} of the stem section underneath it.
Initial estimates of the stem's \emph{feature space} 
are performed on a \emph{baselise} stem segment - i.e.
a low height interval where a tree's bole is expected  
to be clearly visible in the point cloud.
The algorithm is described in detail by Conto et al. (2017).

This adapted version of the algorithm is very robust against outliers, 
but not against forked or leaning stems.
}

\examples{
file = system.file("extdata", "spruce.laz", package="TreeLS")
tls = readTLS(file)

### identify stem points
tls = stemPoints(tls, method = stem.hough(max_radius=.2))
plot(tls, color='Stem')

}
\references{
Conto, T. ; Olofsson, K. ; Gorgens, E. B. ; Rodriguez, L. C. E. ; Almeida, G. Performance of stem denoising and stem modelling algorithms on single tree point clouds from terrestrial laser scanning. Computers and Electronics in Agriculture, v. 143, p. 165-176, 2017.
}
