% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FacetDensityFoldchange.R
\name{facet_density_foldchange}
\alias{facet_density_foldchange}
\title{Create faceted high-density region plots with optional points and density contours}
\usage{
facet_density_foldchange(
  data,
  x_var,
  y_var,
  group_var,
  facet_var,
  palette,
  show_points = FALSE,
  show_density = TRUE,
  point_size = 2.5,
  point_alpha = 0.1,
  line_size = 1.6,
  cor_method = "pearson",
  cor_label_pos = c("left", 0.97),
  cor_vjust = NULL
)
}
\arguments{
\item{data}{Data frame containing variables for plotting.}

\item{x_var}{Name of the x-axis variable as a string.}

\item{y_var}{Name of the y-axis variable as a string.}

\item{group_var}{Name of the grouping variable for color mapping as a string.}

\item{facet_var}{Name of the faceting variable.}

\item{palette}{Color palette for the plot as a character vector.}

\item{show_points}{Logical, if TRUE adds scatter points to the plot.}

\item{show_density}{Logical, if TRUE adds filled density contours to the plot.}

\item{point_size}{Size of the points, relevant if show_points is TRUE.}

\item{point_alpha}{Transparency level of the points, relevant if show_points is TRUE.}

\item{line_size}{Size of the regression line.}

\item{cor_method}{Method to calculate correlation ("pearson" or "spearman").}

\item{cor_label_pos}{Vector of length 2 indicating the position of the correlation label (x and y).}

\item{cor_vjust}{Vertical justification for correlation label, default is NULL.}
}
\value{
A `ggplot` object representing the high-density region plot.
}
\description{
This function creates faceted high-density region plots using ggdensity for
adding optional density rug and density contours, and scatter points. It also adds a regression line
and Pearson correlation label. The plot is faceted by a grouping variable.
}
\examples{
combined_df_file <- system.file("extdata", "combined_df.rds", package = "TransProR")
combined_df <- readRDS(combined_df_file)
pal2 = c("#2787e0","#1a9ae0","#1dabbf","#00897b","#43a047","#7cb342")
all_facet_density_foldchange_name1 <- facet_density_foldchange(
  data = combined_df,
  x_var = "log2FoldChange_1",
  y_var = "log2FoldChange_2",
  group_var = "name",
  facet_var = "name",
  palette = pal2,
  show_points = TRUE,
  show_density = FALSE,
  point_size = 2,
  point_alpha = 0.1,
  line_size = 1.6,
  cor_method = "pearson",
  cor_label_pos = c("left", "top"),
  cor_vjust = 1
)
}
