% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{all_degs_venn}
\alias{all_degs_venn}
\title{All DEGs Venn Diagram Data}
\format{
A list with the following components:
\describe{
  \item{DESeq2}{A vector of gene IDs or gene symbols identified as DEGs by the DESeq2 method.}
  \item{edgeR}{A vector of gene IDs or gene symbols identified as DEGs by the edgeR method.}
  \item{limma}{A vector of gene IDs or gene symbols identified as DEGs by the limma method. }
  \item{Wilcoxon_test}{A vector of gene IDs or gene symbols identified as DEGs by the Wilcoxon test method. }
}
}
\source{
The data was derived from differential expression analyses performed on a gene expression dataset using four commonly used statistical methods (DESeq2, edgeR, limma, and Wilcoxon test).
}
\usage{
data(all_degs_venn)
}
\description{
A dataset containing the differentially expressed genes (DEGs) from four different statistical analysis methods: DESeq2, edgeR, limma, and Wilcoxon test.
This dataset is used for generating Venn diagrams to compare the overlap of DEGs identified by different methods.
}
\examples{
data(all_degs_venn)
# Example of plotting a Venn diagram using the dataset

edge_colors <- c("#1b62bb","#13822e","#332c3a","#9e2d39")
name_color <- c("#1b64bb","#13828e","#337c3a","#9e9d39")
fill_colors <- c("#e3f2fa", "#0288d1")

Contrast_degs_venn <- Contrast_Venn(all_degs_venn, edge_colors, name_color, fill_colors)

}
\keyword{datasets}
