% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_words.R
\name{get_words}
\alias{get_words}
\title{get_words function}
\usage{
get_words(corpus_dates, ntrms, st, path_name, language)
}
\arguments{
\item{corpus_dates}{A vector of characters indicating the subfolders where are located the texts.}

\item{ntrms}{maximum numbers of words  that will be filtered by tf-idf. We rank the word by tf-idf in a decreasing order. Then, we select the words with the ntrms highest tf-idf.}

\item{st}{set 0 to stem the words and 1 otherwise.}

\item{path_name}{the folders path where the subfolders with the dates are located.}

\item{language}{The texts language.}
}
\value{
a list containing  a matrix with the all words couting and another with a td-idf filtered words counting according to the ntrms.
}
\description{
get_words function
}
\examples{
\donttest{
st_year=2017
end_year=2018
path_name=system.file("news",package="TextForecast")
qt=paste0(sort(rep(seq(from=st_year,to=end_year,by=1),12)),
c("m1","m2","m3","m4","m5","m6","m7","m8","m9","m10","m11","m12"))
z_wrd=get_words(corpus_dates=qt[1:23],path_name=path_name,ntrms=500,st=0)
}
path_name=system.file("news",package="TextForecast")
days=c("2019-31-01","2019-31-01")
z_wrd=get_words(corpus_dates=days,path_name=path_name,ntrms=500,st=0)

}
