% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/item_functions.R
\docType{methods}
\name{calcLocation-methods}
\alias{calcLocation-methods}
\alias{calcLocation}
\alias{calcLocation,item_1PL-method}
\alias{calcLocation,item_2PL-method}
\alias{calcLocation,item_3PL-method}
\alias{calcLocation,item_PC-method}
\alias{calcLocation,item_GPC-method}
\alias{calcLocation,item_GR-method}
\alias{calcLocation,item_pool-method}
\title{Calculate central location (overall difficulty)}
\usage{
calcLocation(object)

\S4method{calcLocation}{item_1PL}(object)

\S4method{calcLocation}{item_2PL}(object)

\S4method{calcLocation}{item_3PL}(object)

\S4method{calcLocation}{item_PC}(object)

\S4method{calcLocation}{item_GPC}(object)

\S4method{calcLocation}{item_GR}(object)

\S4method{calcLocation}{item_pool}(object)
}
\arguments{
\item{object}{an \code{\link{item}} or an \code{\linkS4class{item_pool}} object.}
}
\value{
\describe{
  \item{\code{\link{item}} object:}{\code{\link{calcLocation}} returns a theta value representing the central location.}
  \item{\code{\linkS4class{item_pool}} object:}{\code{\link{calcProb}} returns a length \emph{ni} list, each containing the central location of the item.}
}
\describe{
  \item{\emph{notations}}{\itemize{
    \item{\emph{ni} denotes the number of items in an \code{\linkS4class{item_pool}} object.}
  }}
}
}
\description{
\code{\link{calcLocation}} is a function to calculate the central location (overall difficulty) of items.
}
\examples{
item_1      <- new("item_1PL", difficulty = 0.5)
item_2      <- new("item_2PL", slope = 1.0, difficulty = 0.5)
item_3      <- new("item_3PL", slope = 1.0, difficulty = 0.5, guessing = 0.2)
item_4      <- new("item_PC", threshold = c(-1, 0, 1), ncat = 4)
item_5      <- new("item_GPC", slope = 1.2, threshold = c(-0.8, -1.0, 0.5), ncat = 4)
item_6      <- new("item_GR", slope = 0.9, category = c(-1, 0, 1), ncat = 4)

loc_item_1 <- calcLocation(item_1)
loc_item_2 <- calcLocation(item_2)
loc_item_3 <- calcLocation(item_3)
loc_item_4 <- calcLocation(item_4)
loc_item_5 <- calcLocation(item_5)
loc_item_6 <- calcLocation(item_6)
loc_pool   <- calcLocation(itempool_science)

}
\references{
Rasch, G. (1960). \emph{Probabilistic models for some intelligence and attainment tests.}
Copenhagen: Danish Institute for Educational Research.

Lord, F. M. (1952). A theory of test scores (Psychometric Monograph No. 7). Richmond, VA: Psychometric Corporation.

Birnbaum, A. (1957). \emph{Efficient design and use of tests of mental ability for various decision-making problems}
(Series Report No. 58-16. Project No. 7755-23).
Randolph Air Force Base, TX: USAF School of Aviation Medicine.

Birnbaum, A. (1958). \emph{On the estimation of mental ability}
(Series Report No. 15. Project No. 7755-23).
Randolph Air Force Base, TX: USAF School of Aviation Medicine.

Birnbaum, A. (1958). \emph{Further considerations of efficiency in tests of a mental ability}
(Series Report No. 17. Project No. 7755-23).
Randolph Air Force Base, TX: USAF School of Aviation Medicine.

Birnbaum, A. (1968). Some latent trait models and their use in inferring an examinee's ability.
In Lord, F. M., Novick, M. R. (eds.), \emph{Statistical Theories of Mental Test Scores}, 397–479.
Reading, MA: Addison-Wesley.

Masters, G. N. (1982). A Rasch model for partial credit scoring.
\emph{Psychometrika, 47}(2), 149–174.

Andrich, D. (1978). A rating formulation for ordered response categories.
\emph{Psychometrika, 43}(4), 561–573.

Muraki, E. (1992). A generalized partial credit model: Application of an EM algorithm.
\emph{Applied Psychological Measurement, 16}(2), 159–176.

Samejima, F. (1969). Estimation of latent ability using a response pattern of graded scores.
\emph{Psychometrika Monograph, 17}.
}
