% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tQRdwht.R
\name{tQRdwht}
\alias{tQRdwht}
\title{QR decomposition of a 3D tensor using the discrete Walsh Hadley transform}
\usage{
tQRdwht(tnsr)
}
\arguments{
\item{tnsr, }{a 3-mode S3 tensor class object}
}
\value{
Q, The left singular value S3 tensor class object (\eqn{n \times n \times k})

R, The right singular value Se tensor class object (\eqn{n \times n \times k})
}
\description{
QR decomposition of a 3D tensor using the discrete Walsh Hadley transform
}
\examples{
T <- t_rand(modes=c(2,2,4))
tQRdwht(T)
}
\references{
M. E. Kilmer, C. D. Martin, and L. Perrone, “A third-order generalization of the matrix svd as a product of third-order tensors,” Tufts University, Department of Computer Science, Tech. Rep. TR-2008-4, 2008

K. Braman, "Third-order tensors as linear operators on a space of matrices", Linear Algebra and its Applications, vol. 433, no. 7, pp. 1241-1253, 2010.
}
\author{
Kyle Caudle

Randy Hoover

Jackson Cates

Everett Sandbo
}
