% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tQR.R
\name{tQR}
\alias{tQR}
\title{QR decomposition of a 3D tensor}
\usage{
tQR(tnsr, tform)
}
\arguments{
\item{tnsr, }{a 3-mode tensor S3 class object}

\item{tform, }{Any discrete transform.

fft: Fast Fourier Transorm

dwt: Discrete Wavelet Transform (Haar Wavelet)

dct: Discrete Cosine transform

dst: Discrete Sine transform

dht: Discrete Hadley transform

dwht: Discrete Walsh-Hadamard transform}
}
\value{
Q, The left singular value tensor object (\eqn{n \times n \times k})

R, The right singular value tensor object (\eqn{n \times n \times k})
}
\description{
Decomposes a 3 mode tensor T into the product of The left singular value tensor object
and a right singular value tensor object so that T = QR.
}
\examples{
T <- t_rand(modes=c(2,2,4))
tQR(T,"dst")
}
\references{
M. E. Kilmer, C. D. Martin, and L. Perrone, “A third-order generalization of the matrix svd as a product of third-order tensors,” Tufts University, Department of Computer Science, Tech. Rep. TR-2008-4, 2008

K. Braman, "Third-order tensors as linear operators on a space of matrices", Linear Algebra and its Applications, vol. 433, no. 7, pp. 1241-1253, 2010.
}
\author{
Kyle Caudle

Randy Hoover

Jackson Cates

Everett Sandbo
}
