% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{saveTrainedModelAsH5}
\alias{saveTrainedModelAsH5}
\title{Save a trained \code{\linkS4class{SpatialDDLS}} deep neural network model to
disk as an HDF5 file}
\usage{
saveTrainedModelAsH5(object, file.path, overwrite = FALSE)
}
\arguments{
\item{object}{\code{\linkS4class{SpatialDDLS}} object with
\code{trained.model} slot.}

\item{file.path}{Valid file path where to save the model to.}

\item{overwrite}{Overwrite file if it already exists.}
}
\value{
No return value, saves a \pkg{keras} DNN trained model as HDF5 file
on disk.
}
\description{
Save a trained \code{\linkS4class{SpatialDDLS}} deep neural network model to
disk as an HDF5 file. Note that this function does not save the
\code{\linkS4class{DeconvDLModel}} object, only the trained \pkg{keras}
model. This is the alternative to the \code{\link{saveRDS}} and
\code{\link{preparingToSave}} functions if you want to keep the state of the
optimizer.
}
\seealso{
\code{\link{trainDeconvModel}} \code{\link{loadTrainedModelFromH5}}
}
