% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/BRLasso.R
\name{BRLasso}
\alias{BRLasso}
\title{Bootstrap ranking LASSO model.}
\description{
This function performs a LASSO logistic regression model using a bootstrap ranking procedure.
}
\usage{
BRLasso(x, y, B = 5, Boots = 100, kfold = 10)
}
\arguments{
\item{x}{the predictor matrix}

\item{y}{the response variable, a factor object with values of 0 and 1}

\item{B}{the external loop for intersection operation, with the default value 5}

\item{Boots}{the internal loop for bootstrap sampling, with the default value 100}

\item{kfold}{the K-fold cross validation, with the default value 10}
}
\value{
\item{var.selected}{ Variables that are selected by the BRLasso model.}

\item{var.coef}{ Coefficients of the selected variables.}
}
\references{
[1] Guo, P., Zeng, F., Hu, X., Zhang, D., Zhu, S., Deng, Y., & Hao, Y. (2015). Improved Variable Selection 
Algorithm Using a LASSO-Type Penalty, with an Application to Assessing Hepatitis B Infection Relevant Factors 
in Community Residents. PLoS One, 27;10(7):e0134151.
}
\examples{
library(datasets)
head(iris)
X <- as.matrix(subset(iris,iris$Species!="setosa")[, -5])
Y <- as.factor(ifelse(subset(iris,iris$Species!="setosa")[, 5]=='versicolor', 0, 1))
# Fit a bootstrap ranking LASSO (BRLasso) logistic regression model.
# The parameters of B and Boots in the following example are set as small values to
# reduce the running time, however the default values are proposed.
BRLasso.fit <- BRLasso(x=X, y=Y, B=2, Boots=5)
# Variables that are selected by the BRLasso model.
BRLasso.fit$var.selected
# Coefficients of the selected variables.
BRLasso.fit$var.coef
}
