% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_features_consumption.R
\name{calc_featuresco_consumption}
\alias{calc_featuresco_consumption}
\title{Calculates consumption features from weekly consumption only}
\usage{
calc_featuresco_consumption(B, rowname = NULL)
}
\arguments{
\item{B}{a vector of any length with measurements}

\item{rowname}{the row name of the resulting feature vector}
}
\value{
a data.frame with the calculated features as columns and a specified
   rowname, if given
}
\description{
Calculates consumption features from weekly consumption only
}
\references{
Hopf, K. (2019). Predictive Analytics for Energy Efficiency and
    Energy Retailing (1st ed.). Bamberg: University of Bamberg.
    \url{https://doi.org/10.20378/irbo-54833}

Hopf, K., Sodenkamp, M., Kozlovskiy, I., & Staake, T. (2014).
    Feature extraction and filtering for household classification based on
    smart electricity meter data. Computer Science-Research and Development,
    (31) 3, 141–148. \url{https://doi.org/10.1007/s00450-014-0294-4}

Hopf, K., Sodenkamp, M., & Staake, T. (2018). Enhancing energy
    efficiency in the residential sector with smart meter data analytics.
    Electronic Markets, 28(4). \url{https://doi.org/10.1007/s12525-018-0290-9}
}
\author{
Konstantin Hopf \email{konstantin.hopf@uni-bamberg.de}
}
