% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chat_pois.R
\name{chat_pois}
\alias{chat_pois}
\title{Calculate Upper Frechet-Hoeffding Correlation Bound: Poisson - Normal Variables}
\usage{
chat_pois(lam, n_unif = 10000, seed = 1234)
}
\arguments{
\item{lam}{a vector of lambda (> 0) constants for the Poisson variables (see \code{\link[stats]{dpois}})}

\item{n_unif}{the number of uniform random numbers to generate in calculating the bound (default = 10000)}

\item{seed}{the seed used in random number generation (default = 1234)}
}
\value{
A scalar equal to the correlation upper bound.
}
\description{
This function calculates the upper Frechet-Hoeffding bound on the correlation between a Poisson variable
    and the normal variable used to generate it.  It is used in \code{\link[SimMultiCorrData]{findintercorr_cat_pois}}
    and \code{\link[SimMultiCorrData]{findintercorr_cont_pois}} in calculating the intermediate MVN correlations.  This uses
    the method of Amatya & Demirtas (2015, \doi{10.1080/00949655.2014.953534}).  This function would not ordinarily be called directly by the user.
}
\references{
Amatya A & Demirtas H (2015). Simultaneous generation of multivariate mixed data with Poisson and normal marginals.
    Journal of Statistical Computation and Simulation, 85(15): 3129-39. \doi{10.1080/00949655.2014.953534}.

Demirtas H & Hedeker D (2011). A practical way for computing approximate lower and upper correlation bounds.
    American Statistician, 65(2): 104-109. \doi{10.1198/tast.2011.10090}.

Frechet M.  Sur les tableaux de correlation dont les marges sont donnees.  Ann. l'Univ. Lyon SectA.  1951;14:53-77.

Hoeffding W. Scale-invariant correlation theory. In: Fisher NI, Sen PK, editors. The collected works of Wassily Hoeffding.
    New York: Springer-Verlag; 1994. p. 57-107.

Yahav I & Shmueli G (2012). On Generating Multivariate Poisson Data in Management Science Applications. Applied Stochastic
    Models in Business and Industry, 28(1): 91-102. \doi{10.1002/asmb.901}.
}
\seealso{
\code{\link[SimMultiCorrData]{findintercorr_cat_pois}}, \code{\link[SimMultiCorrData]{findintercorr_cont_pois}},
    \code{\link[SimMultiCorrData]{findintercorr}}
}
\keyword{1}
\keyword{Poisson,}
\keyword{correlation,}
\keyword{method}
