% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_constants.R
\name{add_constants}
\alias{add_constants}
\title{Add one or more simulation constants}
\usage{
add_constants(sim, ...)
}
\arguments{
\item{sim}{A simulation object of class \code{sim_obj}, usually created by
new_sim()}

\item{...}{Key-value pairs will be added as "simulation constants" (i.e.
objects that don't change across simulations). Keys should be strings.
The purpose of this (rather than "hard-coding" constants in your scripts)
is to serve as an organizational container to easily change constants
later, and so that constants are automatically available on each cluster
node if you decide to run your simulation code in parallel}
}
\value{
The original simulation object with added constants
}
\description{
Add one or more simulation constants
}
\examples{
sim <- new_sim()
sim \%<>\% add_constants(alpha=4, beta=c(1,2,3))
}
