% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{Analyse}
\alias{Analyse}
\title{Compute estimates and statistics}
\usage{
Analyse(condition, dat, fixed_objects = NULL)
}
\arguments{
\item{condition}{a single row from the design input (as a \code{data.frame}), indicating the
simulation conditions}

\item{dat}{the \code{dat} object returned from the \code{\link{Generate}} function
(usually a \code{data.frame}, \code{matrix}, \code{vector}, or \code{list})}

\item{fixed_objects}{object passed down from \code{\link{runSimulation}}}
}
\value{
returns a named \code{numeric} vector or \code{data.frame} with the values of interest
  (e.g., p-values, effects sizes, etc), or a \code{list} containing values of interest
  (e.g., separate matrix and vector of parameter estimates corresponding to elements in
  \code{parameters}). If a \code{data.frame} is returned with more than 1 row then these
  objects will be wrapped into suitable \code{list} objects
}
\description{
Compute all relevant test statistics, parameter estimates, detection rates, and so on.
This is the computational heavy lifting portion of the Monte Carlo simulation. If
a suitable \code{\link{Generate}} function was not supplied then this function
can be used to be generate and analyse the Monte Carlo data (though in general this
setup is not recommended for larger simulations).
}
\details{
In some cases, it may be easier to change the output to a named \code{list} containing
different parameter configurations (e.g., when
determining RMSE values for a large set of population parameters).

The use of \code{\link{try}} functions is generally not required in this function because \code{Analyse}
is internally wrapped in a \code{\link{try}} call. Therefore, if a function stops early
then this will cause the function to halt internally, the message which triggered the \code{\link{stop}}
will be recorded, and \code{\link{Generate}} will be called again to obtain a different dataset.
That said, it may be useful for users to throw their own \code{\link{stop}} commands if the data
should be re-drawn for other reasons (e.g., an estimated model terminated correctly but the maximum number of
iterations were reached).
}
\examples{
\dontrun{

myanalyse <- function(condition, dat, fixed_objects = NULL){

    # require packages/define functions if needed, or better yet index with the :: operator
    require(stats)
    mygreatfunction <- function(x) print('Do some stuff')

    #wrap computational statistics in try() statements to control estimation problems
    welch <- t.test(DV ~ group, dat)
    ind <- stats::t.test(DV ~ group, dat, var.equal=TRUE)

    # In this function the p values for the t-tests are returned,
    #  and make sure to name each element, for future reference
    ret <- c(welch = welch$p.value,
             independent = ind$p.value)

    return(ret)
}

}
}
\references{
Sigal, M. J., & Chalmers, R. P. (2016). Play it again: Teaching statistics with Monte
Carlo simulation. \code{Journal of Statistics Education, 24}(3), 136-156.
\doi{10.1080/10691898.2016.1246953}
}
\seealso{
\code{\link{stop}}
}
