% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimBoot.R
\name{SimBoot}
\alias{SimBoot}
\title{Function to present bootstrap standard errors estimates for Monte Carlo simulation meta-statistics}
\usage{
SimBoot(results, CI = 0.99)
}
\arguments{
\item{results}{object returned from \code{\link{runSimulation}} where \code{bootSE = TRUE}
was used}

\item{CI}{desired confidence interval level for each meta-statistic using the bootstrap
SE estimate. Default is .99, which constructs a 99\% confidence interval}
}
\description{
This function generates confidence intervals for the meta-statistics called within the
\code{summarise} function with \code{\link{runSimulation}}
that included the argument \code{bootSE = TRUE}.
}
\examples{

\dontrun{
#SimFunctions()

Design <- data.frame(N = c(10, 20, 30))

Generate <- function(condition, fixed_objects = NULL){
    dat <- with(condition, rnorm(N, 10, 5)) # distributed N(10, 5)
    dat
}

Analyse <- function(condition, dat, fixed_objects = NULL){
    CIs <- t.test(dat)$conf.int # t-based CIs
    xbar <- mean(dat) # mean of the sample data vector
    ret <- c(mean=xbar, lowerCI=CIs[1], upperCI=CIs[2])
    ret
}

Summarise <- function(condition, results, fixed_objects = NULL){
    ret <- c(mu=mean(results[,1]), SE=sd(results[,1]), # mean and SD summary of the sample means
             coverage=ECR(results[,2:3], parameter = 10))
    ret
}

res <- runSimulation(design=Design, replications=250, bootSE=TRUE,
                       generate=Generate, analyse=Analyse, summarise=Summarise)

res
SimBoot(res)

# larger R
res2 <- runSimulation(design=Design, replications=2500, bootSE=TRUE,
                       generate=Generate, analyse=Analyse, summarise=Summarise)

# point estimates more accurate, smaller BOOT_SE terms
res2
SimBoot(res2) # more reasonable CI range

}

}
\references{
Sigal, M. J., & Chalmers, R. P. (2016). Play it again: Teaching statistics with Monte
Carlo simulation. \code{Journal of Statistics Education, 24}(3), 136-156.
\doi{10.1080/10691898.2016.1246953}
}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
