% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{generate}
\alias{generate}
\title{Generate data}
\usage{
generate(condition, fixed_objects = NULL)
}
\arguments{
\item{condition}{a single row from the \code{design} input (as a \code{data.frame}), indicating the
simulation conditions}

\item{fixed_objects}{object passed down from \code{\link{runSimulation}}}
}
\value{
returns a single object containing the data to be analyzed (usually a
  \code{vector}, \code{matrix}, or \code{data.frame}),
  or a list with a the elements \code{'dat'} and \code{'parameters'}. If a list is returned
  the \code{'dat'} element should be the observed data object while the
  \code{'parameters'} element should be a named list containing the simulated parameters
  (if there are any. Otherwise, this could just be an empty list)
}
\description{
Generate data from a single row in the \code{design} input (see \code{\link{runSimulation}}).
}
\examples{
\dontrun{

mygenerate <- function(condition, fixed_objects = NULL){

    #require packages/define functions if needed, or better yet index with the :: operator

    N1 <- condition$sample_sizes_group1
    N2 <- condition$sample_sizes_group2
    sd <- condition$standard_deviations

    group1 <- rnorm(N1)
    group2 <- rnorm(N2, sd=sd)
    dat <- data.frame(group = c(rep('g1', N1), rep('g2', N2)), DV = c(group1, group2))
    pars <- list(random_number = rnorm(1)) # just a silly example of a simulated parameter

    #could just use return(dat) if no parameters should be tracked
    return(list(dat=dat, parameters=pars))
}

}

}
\seealso{
\code{\link{add_missing}}
}

