% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SightabilityPopR.R
\name{SightabilityPopR}
\alias{SightabilityPopR}
\title{R function that interfaces with the SightabilityModel package and gives similar functionality
as the AerialSurvey program}
\usage{
SightabilityPopR(
  survey.data,
  survey.block.area,
  stratum.data,
  density = NULL,
  abundance = NULL,
  numerator = NULL,
  denominator = NULL,
  sight.formula = observed ~ 1,
  sight.beta = 10,
  sight.beta.cov = matrix(0, nrow = 1, ncol = 1),
  sight.logCI = TRUE,
  sight.var.method = c("Wong", "SS")[1],
  block.id.var = "Block.ID",
  block.area.var = "Block.Area",
  stratum.var = "Stratum",
  stratum.blocks.var = "Stratum.Blocks",
  stratum.area.var = "Stratum.Area",
  conf.level = 0.9
)
}
\arguments{
\item{survey.data}{A data frame containing counts of moose in each group along with a variable identifying 
the stratum (see stratum.var) and block (see block.id.var)}

\item{survey.block.area}{A data frame containing for each block, the block id (see block.id.var), the
area of the block (see block.area.var). The data frame can contain information for other blocks that
were not surveyed (e.g. for the entire population of blocks) and information from these
additional blocks will be ignored.}

\item{stratum.data}{A data frame containing for each stratum, the stratum id (see stratum.var), the total
number of blocks in the stratum (see stratum.blocks.var) and the total area of the stratum (see stratum.area.var)}

\item{density, abundance, numerator, denominator}{Right-handed formula identifying the variable(s) in the
survey.data data frame for which the density, abundance, or ratio (numerator/denominator) are to be estimated.}

\item{sight.formula}{A formula that identifies the model used
to estimate sightability. For example \code{observed ~ VegCoverClass} would indicate
that sightability is a function of the \code{VegCoverClass} variable in the survey 
data. The left hand variable is arbitrary. The right hand variables must be present
in the survey.data data frame.}

\item{sight.beta}{The vector of estimated coefficients for the logistic regression sightability model.}

\item{sight.beta.cov}{The covariance matrix of \code{sight.beta}}

\item{sight.logCI}{Should confidence intervals for the sightability adjusted estimates be computed
using a normal-based confidence interval on \code{log(abundance)}}

\item{sight.var.method}{What method should be used to estimate the variances after adjusting
for sightability.}

\item{block.id.var}{Name of the variable in the data frames that identifies the block.id (the sampling unit)}

\item{block.area.var}{Name of the variable in data frames that contains the area of the blocks (area of sampling unit)}

\item{stratum.var}{Name of the variable in the data frames that identifies the classical stratum}

\item{stratum.blocks.var}{Name of the variable in the stratum.data data frame that contains the total number of
blocks in the stratum.}

\item{stratum.area.var}{Name of the variable in the stratum.data data.frame that contains the total stratum area.}

\item{conf.level}{Confidence level used to create confidence intervals.}
}
\value{
A data frame containing for each stratum and for all strata (identified as stratum id \code{.OVERALL}), the density,
   or abundance or ratio estimate along with its estimated standard error and large-sample normal-based confidence interval.
   Additional information on the components of variance is also reported.
}
\description{
A stratified random sample of blocks in a survey area is conducted.
 In each block, groups of moose are observed (usually through an aerial survey).
 For each group of moose, the number of moose is recorded along with attributes
 such as sex or age.
 
 The SightabilityPopR() function  adjusts for sightability < 100\%.
}
\examples{
 
##---- See the vignettes for examples on how to run this analysis.

}
\references{
To Be Added.
}
\author{
Schwarz, C. J. \email{cschwarz.stat.sfu.ca@gmail.com}.
}
\keyword{~AerialSurvey}
\keyword{~MoosePop}
