% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SentimentDictionary.R
\name{read}
\alias{read}
\title{Read dictionary from text file}
\usage{
read(file)
}
\arguments{
\item{file}{File name pointing to text file}
}
\value{
Dictionary of type \code{\link{SentimentDictionaryWordlist}},
\code{\link{SentimentDictionaryBinary}} or
\code{\link{SentimentDictionaryWeighted}}
}
\description{
This routine reads a sentiment dictionary from a text file. Such a text file can
be created e.g. via \code{\link{write}}. The dictionary type is recognized 
according to the internal format of the file.
}
\examples{
d.out <- SentimentDictionary(c("uncertain", "possible", "likely"))
write(d.out, "example.dict")
d.in <- read("example.dict")
print(d.in)

d.out <- SentimentDictionary(c("increase", "rise", "more"),
                             c("fall", "drop"))
write(d.out, "example.dict")
d.in <- read("example.dict")
print(d.in)

d.out <- SentimentDictionary(c("increase", "decrease", "exit"),
                             c(+1, -1, -10),
                             rep(NA, 3),
                             intercept=5)
write(d.out, "example.dict")
d.in <- read("example.dict")
print(d.in)

unlink("example.dict")
}
\seealso{
\code{\link{write}} for creating such a file
}
\keyword{dictionary}
