% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssc_propcomp.R
\name{ssc_propcomp}
\alias{ssc_propcomp}
\title{Sample Size Calculation for the Comparison of Proportions in Phase III Clinical Trials}
\usage{
ssc_propcomp(design, ratio, alpha, power, p1, p2, delta)
}
\arguments{
\item{design}{The design of the clinical trials.
\cr 1L
  \cr Testing for equality
\cr 2L
  \cr Superiority trial
\cr 3L
  \cr Non-inferiority trial
\cr 4L
  \cr Equivalence trial.}

\item{ratio}{The ratio between the number of subjects in the treatment arm and that in the control arm.}

\item{alpha}{Type I error rate}

\item{power}{Statistical power of the test (1-type II error rate)}

\item{p1}{The true mean response rate of the treatment arm}

\item{p2}{The true mean response rate of the control arm}

\item{delta}{The prespecified superiority, non-inferiority or equivalence margin}
}
\value{
samplesize
}
\description{
This function aims to calculate sample size for the comparison of proportions
in Phase III clinical trials.
}
\examples{
##The comparison of proportions, an equivalence trial and the equivalence margin is 0.2
ssc_propcomp(design = 4L, ratio = 1, alpha = 0.05, power = 0.8, p1 = 0.75, p2 = 0.80, delta = 0.2)
}
\references{
Chow S, Shao J, Wang H. 2008. Sample Size Calculations in Clinical Research. 2nd Ed. Chapman & Hall/CRC Biostatistics Series.

Yin, G. 2012. Clinical Trial Design: Bayesian and Frequentist Adaptive Methods. John Wiley & Sons.
}
