% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utility_functions.R
\name{SVMFit}
\alias{SVMFit}
\title{SSOSVM Fit function}
\usage{
SVMFit(YMAT, method = "logistic", EPSILON = 1e-05, returnAll = FALSE,
  rho = 1)
}
\arguments{
\item{YMAT}{Data. First column is -1 or 1 indicating the class of each observation. The remaining columns are the coordinates of the data points.}

\item{method}{Choice of function used in SVM. Choices are 'logistic', 'hinge' and 'squareHinge'. Default value is 'logistic"}

\item{EPSILON}{Small perturbation value needed in calculation. Default value is 0.00001.}

\item{returnAll}{Return all of theta values? Boolean with default value FALSE.}

\item{rho}{Sensitivity factor to adjust the level of change in the SVM fit when a new observation is added. Default value 1.0}
}
\value{
A list containing:
\item{THETA}{SVM fit parameters.}
\item{NN}{Number of observation points in YMAT.}
\item{DIM}{Dimension of data.}
\item{THETA_list}{THETA at each iteration (new point observed) as YMAT is fed into the algorithm one data point at a time.}
\item{PSI,OMEGA,CHI}{Intermediate value for PSI, OMEGA, or CHI (depending on method choice) at each iteration (new point observed).}
}
\description{
This is the primary function for uses to fit SVMs using this package.
}
\examples{
Sim<- generateSim(10^4)
m1<-SVMFit(Sim$YMAT)
}
