% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Extend0fromModelMatrixInput.R
\name{Extend0fromModelMatrixInput}
\alias{Extend0fromModelMatrixInput}
\alias{IsExtend0}
\title{A specialized version of Extend0()}
\usage{
Extend0fromModelMatrixInput(
  data,
  freqName,
  hierarchies,
  formula,
  dimVar,
  extend0,
  dVar = NULL,
  avoidHierarchical = FALSE,
  hierarchical_extend0 = !avoidHierarchical & is.null(hierarchies),
  ...
)

IsExtend0(extend0)
}
\arguments{
\item{data}{Input data frame}

\item{freqName}{Name of (existing) frequency variable}

\item{hierarchies}{List of hierarchies, which can be converted by \code{\link{AutoHierarchies}}.
Thus, the variables can also be coded by \code{"rowFactor"} or \code{""}, which correspond to using the categories in the data.}

\item{formula}{A model formula}

\item{dimVar}{The main dimensional variables and additional aggregating variables. This parameter can be  useful when hierarchies and formula are unspecified.}

\item{extend0}{When \code{extend0} is set to \code{TRUE}, the data is automatically extended.
Additionally, \code{extend0} can be specified as a list, representing the \code{varGroups} parameter
in the \code{\link{Extend0}} function.
Can also be set to \code{"all"} which means that input codes in hierarchies
are considered in addition to those in data.}

\item{dVar}{Optional. Specifies the \code{dimVar} input for \code{\link[=Extend0]{Extend0()}}.
If not provided, \code{dimVar} is calculated by the \code{\link[=NamesFromModelMatrixInput]{NamesFromModelMatrixInput()}} function.}

\item{avoidHierarchical}{Parameter passed to \code{\link[=Formula2ModelMatrix]{Formula2ModelMatrix()}} via \code{\link[=ModelMatrix]{ModelMatrix()}}.
The default value (\code{FALSE}) is the same as in the receiving function.}

\item{hierarchical_extend0}{Specifies the \code{hierarchical} input to \code{\link[=Extend0]{Extend0()}}.
By default, it is set to the opposite of \code{avoidHierarchical} when \code{hierarchies} is not provided.
If \code{hierarchies} is provided, \code{hierarchical_extend0} is by default set to \code{FALSE}.
This parameter allows the \code{hierarchical} input to \code{Extend0()} to be specified manually,
independent of the input provided to \code{ModelMatrix()}.}

\item{...}{Further arguments to underlying functions.}
}
\value{
Extended data frame
}
\description{
\code{Extend0fromModelMatrixInput()} is a specialized function that extends the input data based on the provided parameters.
It is designed specifically to work with input to \code{\link[=ModelMatrix]{ModelMatrix()}}.
}
\details{
\itemize{
\item \code{Extend0fromModelMatrixInput()}: The main function that processes and extends input data according to the specified parameters.
\item \code{IsExtend0()}: A helper function that evaluates the \code{extend0} parameter and returns \code{TRUE} or \code{FALSE}, indicating whether the data should be extended.
}
}
\seealso{
\code{\link[=Extend0]{Extend0()}}
}
\keyword{internal}
