% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Methods-ViralPop.R
\name{loadViralPop}
\alias{loadViralPop}
\title{loadViralPop}
\usage{
loadViralPop(directory, listFiles, listCol = list(id = "id", timeObs =
  "time", filename = "filename"), file.extension = "fasta")
}
\arguments{
\item{directory}{path where is data}

\item{listFiles}{a dataframe with host ID, time observation and file name (filename.fasta)}

\item{listCol}{a list of listFiles colomns names ("id", "timeObs", "filename")}

\item{file.extension}{genotype file extension}
}
\value{
a vector of VirlaPop object
}
\description{
Load all ViralPop observated in the file.obs
}
\examples{
\donttest{
path = system.file("extdata", "data-simul/", package="SMITIDstruct")
files <- list.files(path, pattern = ".*.fasta" ,full.names=FALSE)
lfileinfo <- sapply(files,function(x){return(substr(x,1,nchar(x)-6))})
splitFiles <- strsplit(lfileinfo, "_");
listF <- cbind(data.frame(matrix(unlist(splitFiles),nrow=length(splitFiles), byrow=TRUE),
               stringsAsFactors = FALSE), names(splitFiles))
colnames(listF) <- c("id", "time", "filename")
lvpop <- loadViralPop(path,listF)
}
}
