% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{regPath.SDTree}
\alias{regPath.SDTree}
\title{Calculate the regularization path of an SDTree}
\usage{
\method{regPath}{SDTree}(object, cp_seq = NULL, ...)
}
\arguments{
\item{object}{an SDTree object}

\item{cp_seq}{A sequence of complexity parameters.
If NULL, the sequence is calculated automatically using only relevant values.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
An object of class \code{paths} containing
\item{cp}{The sequence of complexity parameters.}
\item{varImp_path}{A \code{matrix} with the variable importance
for each complexity parameter.}
\item{type}{Path type}
}
\description{
This function calculates the variable importance of an SDTree
for different complexity parameters.
}
\examples{
set.seed(1)
n <- 10
X <- matrix(rnorm(n * 5), nrow = n)
y <- sign(X[, 1]) * 3 + sign(X[, 2]) + rnorm(n)
model <- SDTree(x = X, y = y, Q_type = 'no_deconfounding', cp = 0.5)
paths <- regPath(model)
plot(paths)
\donttest{
plot(paths, plotly = TRUE)
}
}
\seealso{
\code{\link{plot.paths}} \code{\link{prune}} \code{\link{get_cp_seq}} \code{\link{SDTree}}
}
\author{
Markus Ulmer
}
